<?php
// subscribe-api.php
require_once 'db.php';

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Get raw JSON input
$json = file_get_contents('php://input');
$data = json_decode($json);

// Check if JSON decoding failed
if (json_last_error() !== JSON_ERROR_NONE || !isset($data->email)) {
    echo json_encode([
        "status" => "error",
        "message" => "Invalid JSON input or email missing"
    ]);
    exit();
}

$email = trim($data->email);

// Validate email format
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode([
        "status" => "error",
        "message" => "Invalid email format"
    ]);
    exit();
}

// Create connection (assuming db.php sets up $conn as mysqli connection)
global $conn;

try {
    // Sanitize email input
    $sanitizedEmail = $conn->real_escape_string($email);

    // Check if email already exists
    $checkQuery = "SELECT id FROM Subscribe WHERE email = '$sanitizedEmail' AND delete_status = 0";
    $checkResult = $conn->query($checkQuery);
    
    if ($checkResult->num_rows > 0) {
        echo json_encode([
            "status" => "error",
            "message" => "Email already subscribed"
        ]);
        exit();
    }

    // Insert new subscription
    $query = "INSERT INTO Subscribe (email) VALUES ('$sanitizedEmail')";
    $result = $conn->query($query);
    
    if ($result) {
        echo json_encode([
            "status" => "success",
            "message" => "Subscription successful",
            "data" => [
                "id" => $conn->insert_id,
                "email" => $email
            ]
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Unable to subscribe: " . $conn->error
        ]);
    }
} catch(Exception $e) {
    echo json_encode([
        "status" => "error",
        "message" => "Database error: " . $e->getMessage()
    ]);
}

// Close connection
$conn->close();
?>